'Nome       : Listagem de Documentos.dec
'Tipo       : CFR
'Data       : 2001/09/04
'Versao     : 1.0
'Descricao  : 

'-------------------------------------------------------------------------------
#DEF - Definicao global do documento
'-------------------------------------------------------------------------------
Caracteres invalidos             [CarInv]=#
##


'-------------------------------------------------------------------------------
#ESP - Campos especificos
'-------------------------------------------------------------------------------
Zoom para preview             [PrvZoom]=1.5
Opcoes para impressora WIN   [PrWinOpc]=[ORI=P]
##


'-------------------------------------------------------------------------------
#SQL - Comandos SQL
'-------------------------------------------------------------------------------
Base de dados           [BD]=EmpFic$("EMP","Cemp,Emp_Dat.mdb")

Dados a listar [Cmd]=GerDli=+
+SELECT EmdDoc.Tdoc$ AS C01,EmdDoc.Ndoc$ AS C02,EmdDoc.Dtl AS C03,CtaMst.Nome$ AS C04,EmdDoc.Vl AS C05 +
+FROM (EmdDoc INNER JOIN CtaMst ON EmdDoc.Ct$=CtaMst.Ct$) INNER JOIN CtaAng ON EmdDoc.Ct$=CtaAng.Ct$ +
+WHERE EmdDoc.[Ndoc$] BETWEEN '{Opc_Ndoc.Ini}' AND '{Opc_Ndoc.Fim}' AND EmdDoc.Dtl= {Opc_DtDia_Pct} +
+ORDER BY EmdDoc.Tdoc$,EmdDoc.Ndoc$
##


'-------------------------------------------------------------------------------
#DOC - Configuracao do documento
'-------------------------------------------------------------------------------
Tipo                       [DocTip]=SQL
Nome                       [DocNom]=Doc1,Listagem de Documentos (TEXTO)
Vias                       [DocVia]=Original

'formato
Saida/Impressora           [DocPrt]=
Linhas por pagina          [DocLpg]=50
Colunas por linha          [DocCol]=80
Formato do papel           [DocPap]=72L
Ajustar pagina             [DocApg]=0
Especifico do documento    [DocEsp]=TipoLst=TXT

'funcoes de listagem
Listar cabecalho            [FxCAB]=Doc1_Cab
Listar linhas               [FxLIN]=Doc1_Lin
Listar fim                  [FxFIM]=Doc1_Fim

'controlo de listagem SQL
Gerador de dados a listar  [SQLDat]=GerDli
Subtotalizadores           [SQLSbt]=
##


'-------------------------------------------------------------------------------
#DOC - Configuracao do documento
'-------------------------------------------------------------------------------
Tipo                       [DocTip]=SQL
Nome                       [DocNom]=Doc2,Listagem de Documentos (GRAFICO)
Vias                       [DocVia]=Original
Personalizacao             [DocPer]=

'formato
Saida/Impressora           [DocPrt]=PAG_W
'Saida/Impressora           [DocPrt]=PAG_W,PRV
Linhas por pagina          [DocLpg]=50
Colunas por linha          [DocCol]=78
Formato do papel           [DocPap]=72L
Ajustar pagina             [DocApg]=0
Especifico do documento    [DocEsp]=TipoLst=GRF

'funcoes de listagem
Listar cabecalho            [FxCAB]=Doc2_Cab
Listar linhas               [FxLIN]=Doc2_Lin
Listar fim                  [FxFIM]=Doc2_Fim

'controlo de listagem SQL
Gerador de dados a listar  [SQLDat]=GerDli
Subtotalizadores           [SQLSbt]=
##


'-------------------------------------------------------------------------------
#VAR - Variaveis
'-------------------------------------------------------------------------------
Tipo     = MemTxt$(1)
Pag      = Doc_CntPag
DataExt  = FrmVal$(Sig_DtHoje,45,0)


TotNr    = FrmNum$(6.0,TotNr)
SbtId    = SbtIde$
SbtNr    = FrmNum$(6.0,SbtNr)

'Campos
C01 = left$(SqlCmp$("C01"), 4)
C02 = FrmNdo$("06","",SqlCmp$("C02"))
C03 = FrmDt$("",SqlCmp("C03"))
C04 = left$(SqlCmp$("C04"), 30)
C05 = FrmMoe$("", 17,SqlCmp("C05"))
C05_T0=FrmNum$( 14.2,Total(C05,0))
C05_N0=FrmNum$(6.0,TotCnt("C01",0))
T05   =FrmNum$( 14.2,Total(C05,0))

'Subtotais
##


'-------------------------------------------------------------------------------
#PGM - Programa/Funcoes
'-------------------------------------------------------------------------------
SUB FxIni 'funcao de inicializacao
'modo WIN
PrWIN AJT_F, 56.7,  56.7                           'ajuste para milimetros
PrWIN AJT_D,-280.0,-280.0                          'deslocamento de ajuste
'PrWIN IMG_F, 1, VarTx$("[SIG_DIR.DIV],OliLogo.bmp","R")     'imagem (logotipo)
PrWIN ET,  2                                       'espessura de traco

dimLinNor=4.4                                      'altura de uma linha normal
dimLinCab=6.6                                      'altura de uma linha de cabecalho

cnt=0                                              'limpar contador
end sub


SUB FxFim 'funcao de finalizacao
PrWIN FON, "REG"                                   'limpar registo de fontes
end sub


SUB Lst_AJT 'ajuste
end sub



'- Doc1 ------------------------------------------------------------------------
SUB Doc1_FimAjt 'fim de pagina intermedia
'TotNr=TotCnt("C01",0)                             'numero de registos
?================================================================================
'if UsaTot > 0 then
'?  Total   :           @TotNr                                @T05               #
'?================================================================================
'print "Linhas:" Doc_CntLin                        'numero da linha - DEBUG
'end if

FxDiv LstPer,SP                                    'fim de pagina
'Print PrtCmd("[SP]");                             'fim de pagina
end sub


SUB Doc1_CabIni 'inicializar listagem
cntDoc=0
UsaTot=1
end sub


SUB Doc1_Cab 'cabecalho de listagem
FxDiv LstIde,10CPI,0
print TxTit$("TT=10CPI, LD, PT=40C, TL=10CPI",MemTxt$(1))
?Data : @DataExt                                                 Folha No : @Pag#
'123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.
?================================================================================
?Tipo Numero de do Data de la              Nome                    Valor
?================================================================================
'AAAA 123,456/SSSS AAAA/MM/DD AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA 99,999,999,990.00
'<--> <----------> <--------> <----------------------------> <--------------->
end sub


SUB Doc1_Lin 'linha de valores
?@C01 @C02         @C03       @C04                           @C05               #
end sub


SUB Doc1_Fim 'fim de listagem
TotNr=TotCnt("C01",0)                              'numero de registos
'123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.
?================================================================================
if UsaTot > 0 then
?  Total   :           @TotNr                                @T05               #
?================================================================================
'print "Linhas:" Doc_CntLin                        'numero da linha - DEBUG
end if

FxDiv LstPer,SP                                    'fim de pagina
'Print PrtCmd("[SP]");                             'fim de pagina
end sub



'- Doc2 ------------------------------------------------------------------------
Sub Cab132 'cabecalho para 132 colunas
PrWIN AJT_B, 10.0, 0.0                             'posicao base

cabX1=3                                            'limite X1
cabX2=190                                          'limite X2
cabY1=25                                           'limite Y1
cabY2=cabY1+CabLin*dimLinCab                       'limite Y2
cabYm=cabY2+55*dimLinNor                           'limite Y maximo

PrWIN COR_F, 15                                    'cor de fundo

PrWIN FON, 10, 1                                   'activar fonte
'PrWIN TX_N, cabX2-100,  5,VarTx$(EMP_INF_NOME$)    'nome da empresa
PrWIN TX_N, cabX2-100,  5,EmpCurIde$("IDE")        'nome da empresa
PrWIN FON, 18, 1                             	   'activar fonte
PrWin FON, "BOLD+"                                 'activar bold
PrWIN TX_CTR,  cabX1, 5, cabX2, cabY1,MemTxt$(1)   'titulo centrado
PrWin FON, "BOLD-"                                 'desactivar bold
PrWIN FON, 10, 1                             	   'activar fonte

py   =cabY1-dimLinNor-1                            'posicao Y
pxFol=CabX2-30                                     'posicao X para folha
pxPag=CabX2-10                                     'posicao X para pagina

PrWIN TX_N,   05, py,"Data :"                      'data
PrWIN TX_N,   16, py,@DataExt                      'listar data
PrWIN TX_N,pxFol, py,"Folha No :"                  'folha
PrWIN TX_N,pxPag, py,@Pag                          'numero da folha

PrWIN COR_E, 200, 200, 200                         'cor de enchimento RGB
PrWIN GR_ME, 0                                     'modo de enchimento

PrWIN GR_CE,  cabX1, cabY1, cabX2, cabY2, 2        'caixa do cabecalho

if UsaEnv=1 then
PrWIN GR_CX,  cabX1, cabY1, cabX2, cabYm, 2     'caixa envolvente
end if
End Sub


SUB Doc2_Cab 'cabecalho
CabLin = 1                                         'linhas de cabecalho
call Cab132                                        'listar cabecalho
PrWIN AJT_B,  8.0, 0.0                             'posicao base

PrWin FON, "BOLD+"                                 'activar bold
call Doc2_CabCol                                   'titulos das colunas
PrWin FON, "BOLD-"                                 'desactivar bold
end sub


SUB Doc2_LinPos 'posicao de linha
PrWIN AJT_B,  8, 31+Doc_CntLin*4.4                 'posicao base
'PrWIN TX_N,  -3,  0,Doc_CntLin                    'numero da linha - DEBUG
end sub


SUB Doc2_Lin 'linha
call Doc2_LinPos                                   'posicionar linha
call Doc2_LinCol                                   'listar colunas
end sub


SUB Doc2_Fim 'fim de listagem
TotNr=TotCnt("C01",0)                              'numero de registos
tmp=CntLin("INC",-2)                               'contar linha (sem nova pagina)
call Doc2_LinPos                                   'posicionar linha
if UsaTot > 0 then
call Doc2_FimCol                                'listar totais
end if

PrWIN FP                                           'fim de pagina
end sub


SUB Doc2_FimAjt 'fim de pagina intermedia
'TotNr=TotCnt("C01",0)                             'numero de registos
'tmp=CntLin("INC",-1)                              'contar linha (sem nova pagina)
'call Doc2_LinPos                                  'posicionar linha
'if UsaTot > 0 then
'   call Doc2_FimCol                               'listar totais
'end if

PrWIN FP                                           'fim de pagina
end sub


SUB Doc2_CabIni 'inicializar listagem
cntDoc=0                                           'limpar contador
UsaTot=1                                  'usar totais
UsaEnv=1                                  'usar envolvente
UsaSpc=1                                  'usar separador de colunas
end sub


SUB Doc2_CabCol
PrWIN TX_CTR,  5.0,cabY1, 15.5,cabY2,"Tipo de documento"
PrWIN TX_CTR, 15.5,cabY1, 42.8,cabY2,"Numero de documento"
PrWIN TX_CTR, 42.8,cabY1, 65.9,cabY2,"Data de lanamento"
PrWIN TX_CTR, 65.9,cabY1,131.0,cabY2,"Nome"
PrWIN TX_CTR,131.0,cabY1,166.7,cabY2,"Valor"

if UsaSpc > 0 then
PrWIN GR_LI, 15.5,cabY1, 15.5,cabYm,2
PrWIN GR_LI, 42.8,cabY1, 42.8,cabYm,2
PrWIN GR_LI, 65.9,cabY1, 65.9,cabYm,2
PrWIN GR_LI,131.0,cabY1,131.0,cabYm,2
PrWIN GR_LI,166.7,cabY1,166.7,cabYm,2
end if
end sub


SUB Doc2_LinCol
PrWIN TX_N,  6.0,0,@C01
PrWIN TX_NP, 16.5,0,"N",@C02
PrWIN TX_N, 43.8,0,@C03
PrWIN TX_N, 66.9,0,@C04
PrWIN TX_NP,132.0,0,"N",@C05
end sub


SUB Doc2_FimCol
PrWIN TX_NP, 10.0,0,"N",@TotNr
PrWIN TX_N, 18.5,0,"Totais:"
PrWIN TX_NP,132.0,0,"N",@T05
end sub


##


'-------------------------------------------------------------------------------
#GRP - Grupos
'-------------------------------------------------------------------------------
Identificacao                        [Ide]=DefBas
Tipo de listagem                  [TipLst]=10CPI_080

Colunas por linha                 [ColLin]=80
Tipo de letra                     [TipLtr]=10CPI

Separacao entre colunas           [ColSep]=1
Titulo da listagem                [LstTit]=Listagem de Documentos
Informacao adicional              [InfAdi]=Informao Adicional

'opcoes para modo TEXTO
Identificacao de total          [T_TotIde]=Total   :           @TotNr
Identificacao de subtotal       [T_SbtIde]=Subtotal: @SbtId    @SbtNr
Posicao X para total/subtotal    [T_TotPx]=2

'opcoes para modo GRAFICO
Identificacao de total          [G_TotIde]=Total   :
Identificacao de subtotal       [G_SbtIde]=Subtotal:
Posicao X para total/subtotal    [G_TotPx]=20
Dimensao X para total/subtotal   [G_TotDx]=90
Dimensao X para grupo subtotal   [G_GrpDx]=40

Posicao X minima                  [G_Xmin]=5
Posicao X maxima                  [G_Xmax]=190
Distancia X para coluna          [G_ColDx]=1
Dimensao X para caracteres       [G_CarDx]=2.1
Usa separador de colunas        [G_UsaSpc]=1
Usa envolvente                  [G_UsaEnv]=1

'dados a usar
Grupos a usar              [GrpUsa]=Emd_Doc,Cta_Mst,Cta_Ang
Grupo corrente             [GrpCur]=EMD_DOC
Base de dados para SQL      [SqlDb]=EmpFic$("EMP","Cemp,Emp_Dat.mdb")
##


'-------------------------------------------------------------------------------
#GRP.CMP - Campos por grupo
'-------------------------------------------------------------------------------
'formatos para totalizadores
TotV [TOT]=C[>CmpNum<]_T[>SbtNum<]=FrmNum$([>CmpFrmV<],Total(C[>CmpNum<],[>SbtNum<]))
TotN [CNT]=C[>CmpNum<]_N[>SbtNum<]=FrmNum$([>CmpFrmN<],TotCnt("C01",[>SbtNum<]))
##


'-------------------------------------------------------------------------------
#GRP - Grupos
'-------------------------------------------------------------------------------
Identificacao                 [Ide]=VarFix
##


'-------------------------------------------------------------------------------
#GRP.CMP - Campos por grupo
'-------------------------------------------------------------------------------
Tipo     = MemTxt$(1)
Pag      = Doc_CntPag
DataExt  = FrmVal$(Sig_DtHoje,45,0)


TotNr    = FrmNum$(6.0,TotNr)
SbtId    = SbtIde$
SbtNr    = FrmNum$(6.0,SbtNr)
##


'-------------------------------------------------------------------------------
#GRP - Grupos
'-------------------------------------------------------------------------------
Identificacao       [Ide]=CmpUsa01
##


'-------------------------------------------------------------------------------
#GRP.CMP - Campos por grupo
'-------------------------------------------------------------------------------
[IDE=C01][COD=EMD_DOC_Tdoc][DES=Tipo de documento][TPC=V][EXP=Emd_Doc_Tdoc$][FRM=4+1][TPV=T][SBT=][LIM=][TOT=0][ORD=1][ASP=left$([VAR],[DIG])][DIV=]
[IDE=C02][COD=EMD_DOC_Ndoc][DES=Numero de documento][TPC=V][EXP=Emd_Doc_Ndoc$][FRM=12+1][TPV=ND][SBT=][LIM=?][TOT=0][ORD=1][ASP=FrmNdo$("06","",[VAR])][DIV=]
[IDE=C03][COD=EMD_DOC_Dtl][DES=Data de lanamento][TPC=V][EXP=Emd_Doc_Dtl][FRM=10+1][TPV=D][SBT=][LIM=?][TOT=0][ORD=0][ASP=FrmDt$("",[VAR])][DIV=]
[IDE=C04][COD=CTA_MST_Nome][DES=Nome][TPC=V][EXP=Cta_Mst_Nome$][FRM=30+1][TPV=T][SBT=][LIM=][TOT=0][ORD=0][ASP=left$([VAR],[DIG])][DIV=]
[IDE=C05][COD=EMD_DOC_Vl][DES=Valor][TPC=V][EXP=Emd_Doc_Vl][FRM=14.2+1][TPV=N][SBT=][LIM=][TOT=1][ORD=0][ASP=FrmMoe$("",[NDI],[VAR])][DIV=]
##


'-------------------------------------------------------------------------------
#GRP - Grupos
'-------------------------------------------------------------------------------
Identificacao       [Ide]=FxPgm
##


'-------------------------------------------------------------------------------
#GRP.CMP - Campos por grupo
'-------------------------------------------------------------------------------
'-----------------------------------------------------------------------------
' Funcoes para inicializacao
'-----------------------------------------------------------------------------
'<------------------------------------------------>'posicao de comentario

SUB I_FxIni 'funcao de inicializacao
'modo WIN
PrWIN AJT_F, 56.7,  56.7                           'ajuste para milimetros
PrWIN AJT_D,-280.0,-280.0                          'deslocamento de ajuste
'PrWIN IMG_F, 1, VarTx$("[SIG_DIR.DIV],OliLogo.bmp","R")     'imagem (logotipo)
PrWIN ET,  2                                       'espessura de traco

dimLinNor=4.4                                      'altura de uma linha normal
dimLinCab=6.6                                      'altura de uma linha de cabecalho

cnt=0                                              'limpar contador
end sub


SUB I_FxFim 'funcao de finalizacao
PrWIN FON, "REG"                                   'limpar registo de fontes
end sub


'-----------------------------------------------------------------------------
' Funcoes diversas
'-----------------------------------------------------------------------------
SUB D_Lst_AJT 'ajuste
end sub


'-----------------------------------------------------------------------------
' Listagem em modo TEXTO
'-----------------------------------------------------------------------------
SUB T_$Doc1_CabIni 'inicializar listagem
cntDoc=0
UsaTot=[>UsaTot<]
end sub


SUB T_$Doc1_Cab 'cabecalho de listagem
FxDiv LstIde,10CPI,0
print TxTit$("TT=10CPI, LD, PT=40C, TL=10CPI",MemTxt$(1))
?Data : @DataExt                                                 Folha No : @Pag#
'123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.
?================================================================================
?[>ColCab<]
?================================================================================
'[>RegSim<]
'[>RegDim<]
end sub


SUB T_$Doc1_Lin 'linha de valores
?[>ColLin<]
end sub


SUB T_$Doc1_LinTit[>SbtNum<] 'titulo de subtotal [>SbtNum<]
tmp=CntLin("MIN",5)                                'minimo de linhas
tmp=CntLin("INC",1)                                'contar linha

grp$=SbtInf$("ACT",[>SbtNum<])                     'grupo
tmp =SqlOpcAct("Grp",grp$)                         'actualizar valor do grupo
'grVer$=xxxFrmXyz$(grp$)                           'formatar
grVer$=grp$                                        'copiar

ide$=SqlCalc$("GrpIde")                            'pesquisar identificador de grupo
print tab(5) "Grupo : " grVer$ "     " ide$        'identificar grupo

'tmp=CntLin("INC",1)                               'contar linha
'print                                             'separar

'print "Linhas:" Doc_CntLin                        'numero da linha - DEBUG
end sub


SUB T_$Doc1_LinSbt[>SbtNum<] 'valor de subtotal [>SbtNum<]
grp$   =SbtInf$("ANT",[>SbtNum<])                  'grupo
'grVer$=xxxFrmXyz$(grp$)                           'formatar
grVer$ =grp$                                       'copiar
SbtIde$=grVer$                                     'identificacao de subtotal
SbtNr  =TotCnt("C01",[>SbtNum<])                   'numero de registos

?[>ColSbt<]
?

tmp=CntLin("INC",2)                                'contar linhas
x=TotLpz([>SbtNum<])                               'limpar totais

'print "Linhas:" Doc_CntLin                        'numero da linha - DEBUG
end sub


SUB T_$Doc1_Fim 'fim de listagem
TotNr=TotCnt("C01",0)                              'numero de registos
'123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.
?================================================================================
if UsaTot > 0 then
?[>ColFim<]
?================================================================================
'print "Linhas:" Doc_CntLin                        'numero da linha - DEBUG
end if

FxDiv LstPer,SP                                    'fim de pagina
'Print PrtCmd("[SP]");                             'fim de pagina
end sub


SUB T_Doc1_FimAjt 'fim de pagina intermedia
'TotNr=TotCnt("C01",0)                             'numero de registos
?================================================================================
'if UsaTot > 0 then
'?[>ColFim<]
'?================================================================================
'print "Linhas:" Doc_CntLin                        'numero da linha - DEBUG
'end if

FxDiv LstPer,SP                                    'fim de pagina
'Print PrtCmd("[SP]");                             'fim de pagina
end sub


'-----------------------------------------------------------------------------
' Listagem em modo WINDOWS
'-----------------------------------------------------------------------------
Sub G_Cab132 'cabecalho para 132 colunas
PrWIN AJT_B, 10.0, 0.0                             'posicao base

cabX1=3                                            'limite X1
cabX2=190                                          'limite X2
cabY1=25                                           'limite Y1
cabY2=cabY1+CabLin*dimLinCab                       'limite Y2
cabYm=cabY2+55*dimLinNor                           'limite Y maximo

PrWIN COR_F, 15                                    'cor de fundo

PrWIN FON, 10, 1                                   'activar fonte
'PrWIN TX_N, cabX2-100,  5,VarTx$(EMP_INF_NOME$)    'nome da empresa
PrWIN TX_N, cabX2-100,  5,EmpCurIde$("IDE")        'nome da empresa
PrWIN FON, 18, 1                             	   'activar fonte
PrWin FON, "BOLD+"                                 'activar bold
PrWIN TX_CTR,  cabX1, 5, cabX2, cabY1,MemTxt$(1)   'titulo centrado
PrWin FON, "BOLD-"                                 'desactivar bold
PrWIN FON, 10, 1                             	   'activar fonte

py   =cabY1-dimLinNor-1                            'posicao Y
pxFol=CabX2-30                                     'posicao X para folha
pxPag=CabX2-10                                     'posicao X para pagina

PrWIN TX_N,   05, py,"Data :"                      'data
PrWIN TX_N,   16, py,@DataExt                      'listar data
PrWIN TX_N,pxFol, py,"Folha No :"                  'folha
PrWIN TX_N,pxPag, py,@Pag                          'numero da folha

PrWIN COR_E, 200, 200, 200                         'cor de enchimento RGB
PrWIN GR_ME, 0                                     'modo de enchimento

PrWIN GR_CE,  cabX1, cabY1, cabX2, cabY2, 2        'caixa do cabecalho

if UsaEnv=1 then
PrWIN GR_CX,  cabX1, cabY1, cabX2, cabYm, 2     'caixa envolvente
end if
End Sub


SUB G_Doc2_Cab 'cabecalho
CabLin = 1                                         'linhas de cabecalho
call Cab132                                        'listar cabecalho
PrWIN AJT_B,  8.0, 0.0                             'posicao base

PrWin FON, "BOLD+"                                 'activar bold
call Doc2_CabCol                                   'titulos das colunas
PrWin FON, "BOLD-"                                 'desactivar bold
end sub


SUB G_Doc2_LinPos 'posicao de linha
PrWIN AJT_B,  8, 31+Doc_CntLin*4.4                 'posicao base
'PrWIN TX_N,  -3,  0,Doc_CntLin                    'numero da linha - DEBUG
end sub


SUB G_Doc2_Lin 'linha
call Doc2_LinPos                                   'posicionar linha
call Doc2_LinCol                                   'listar colunas
end sub


SUB G_Doc2_Fim 'fim de listagem
TotNr=TotCnt("C01",0)                              'numero de registos
tmp=CntLin("INC",-2)                               'contar linha (sem nova pagina)
call Doc2_LinPos                                   'posicionar linha
if UsaTot > 0 then
call Doc2_FimCol                                'listar totais
end if

PrWIN FP                                           'fim de pagina
end sub


SUB G_Doc2_FimAjt 'fim de pagina intermedia
'TotNr=TotCnt("C01",0)                             'numero de registos
'tmp=CntLin("INC",-1)                              'contar linha (sem nova pagina)
'call Doc2_LinPos                                  'posicionar linha
'if UsaTot > 0 then
'   call Doc2_FimCol                               'listar totais
'end if

PrWIN FP                                           'fim de pagina
end sub


'- Matrizes para Doc2 --------------------------------------------------------
SUB G_$Doc2_CabIni 'inicializar listagem
cntDoc=0                                           'limpar contador
UsaTot=[>UsaTot<]                                  'usar totais
UsaEnv=[>UsaEnv<]                                  'usar envolvente
UsaSpc=[>UsaSpc<]                                  'usar separador de colunas
end sub


SUB G_$Doc2_LinTit[>SbtNum<] 'titulo de subtotal [>SbtNum<]
tmp=CntLin("MIN",5)                                'minimo de linhas
tmp=CntLin("INC",1)                                'contar linha

grp$=SbtInf$("ACT",[>SbtNum<])                     'grupo
tmp =SqlOpcAct("Grp",grp$)                         'actualizar valor do grupo
'grVer$=xxxFrmXyz$(grp$)                           'formatar
grVer$=grp$                                        'copiar

ide$=SqlCalc$("GrpIde")                            'pesquisar identificador de grupo
txi$="Grupo : "+grVer$+"     "+ide$                'identificar grupo

call Doc2_LinPos                                   'posicionar linha
PrWIN TX_N, 06,  0,txi$                            'listar identificacao de grupo
end sub


SUB G_$Doc2_LinSbt[>SbtNum<] 'valor de subtotal [>SbtNum<]
grp$   =SbtInf$("ANT",[>SbtNum<])                  'grupo
'grVer$=xxxFrmXyz$(grp$)                           'formatar
grVer$ =grp$                                       'copiar
SbtIde$=grVer$                                     'identificacao de subtotal
SbtNr  =TotCnt("C01",[>SbtNum<])                   'numero de registos

tmp=CntLin("INC",1)                                'contar linha
call Doc2_LinPos                                   'posicionar linha
call Doc2_LinSbt[>SbtNum<]Col                      'listar valores

tmp=CntLin("INC",1)                                'contar linha
x=TotLpz([>SbtNum<])                               'limpar totais
end sub

##

