'Nome       : EncDocCom_Pgm.inc
'Tipo       : INC
'Data       : 2010/10/08
'Versao     : 1.0
'Descricao  : Inclusao de funcoes para documentos ENC

'==============================================================================
'#VER - Historia de modificacoes
'==============================================================================
'- Versao : 1.0   ____/__/__ --------------------------------------------------
'Versao base


'==============================================================================
'INF - Informacaoes
'==============================================================================
'Incluir este ficheiro a seguir a zona PGM
'
'Exemplo:
'Funcoes para IVA              =[SIG_DOC_DIR.ENC],EncDocCom_Pgm.inc
'
'Ver exemplo em StdFac.imp ou StdFac.ipw


'------------------------------------------------------------------------------
'Exemplo de alteracoes a executar para usar dados do IVA
'------------------------------------------------------------------------------
'Sub DocFim 'total do documento
'comandos a incluir
'IvaLinMax = 4                                          'maximo de linhas para IVA
'call EncDocCom_PrpLstIva                               'preparar listagem do IVA
'
'comandos existentes
'...
'end sub


'==============================================================================
#PGM - Programa/Funcoes
'==============================================================================
'- +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
'- (13) --->'Comentario
'- (25) --------------->'Comentario
'- (28) ------------------>'Comentario
'- (40) ------------------------------>'Comentario
'- (43) --------------------------------->'Comentario
'- (46) ------------------------------------>'Comentario
'- (49) --------------------------------------->'Comentario
'- (52) ------------------------------------------>'Comentario
'- (55) --------------------------------------------->'Comentario
'- (58) ------------------------------------------------>'Comentario
'- (61) --------------------------------------------------->'Comentario
'- (64) ------------------------------------------------------>'Comentario
'- (67) --------------------------------------------------------->'Comentario
'- (70) ------------------------------------------------------------>'Comentario


'==============================================================================
'#IVA - Preparar listagem do IVA
'==============================================================================
Sub EncDocCom_PrpLstIva 'preparar listagem do IVA
'linMax = 4                            'maximo de linhas para IVA
linMax = IvaLinMax                     'maximo de linhas para IVA

'maxTaxIva = 9                         'maximo de taxas de IVA
'maxTaxIva = 99                        'maximo de taxas de IVA
maxTaxIva = IvaTabTip("NTX")           'maximo de taxas de IVA

'msgbox "","Tax Iva", maxTaxIva


'procesar lista de taxas
cntTaxIva = 0                          'contagem de taxas usadas
linIdx    = 0                          'indice para linha

'valores nao discriminados
ivaTax99$ = ""                         'taxa
ivaInc99$ = ""                         'valor de incidencia
ivaVal99$ = ""                         'valor do iva

vIvaInc99 = 0                          'valor de incidencia
vIvaVal99 = 0                          'valor do iva


'linha 1
ivaCod01$ = ""                         'codigo
ivaTax01$ = ""                         'taxa
ivaInc01$ = ""                         'valor de incidencia
ivaVal01$ = ""                         'valor do iva

'linha 2
ivaCod02$ = ""                         'codigo
ivaTax02$ = ""                         'taxa
ivaInc02$ = ""                         'valor de incidencia
ivaVal02$ = ""                         'valor do iva

'linha 3
ivaCod03$ = ""                         'codigo
ivaTax03$ = ""                         'taxa
ivaInc03$ = ""                         'valor de incidencia
ivaVal03$ = ""                         'valor do iva

'linha 4
ivaCod04$ = ""                         'codigo
ivaTax04$ = ""                         'taxa
ivaInc04$ = ""                         'valor de incidencia
ivaVal04$ = ""                         'valor do iva


'preparar taxas usadas
for idx = 1 to maxTaxIva
vCod$ = FrmNum$(2, idx)                'codigo do iva
vTax  = IvaTax(idx)                    'taxa do iva
vInc  = AdoIvaInc("T", idx)            'valor de incidencia
vIva  = AdoIvaVal("T", idx)            'valor do IVA

'tmp$ = idx + " T="+ vTax + " I=" + vInc + " V=" + vIva+ " C="+ vCod$ + "<"
'msgbox "","Iva", tmp$

if vInc <> 0 then                            'ha valor de incidencia ?
   cntTaxIva = cntTaxIva + 1                 'incrementar contagem de taxas usadas

   linIdx = linIdx + 1                       'linha a usar
   if linIdx > linMax then                   'acima do limite de listagem ?
      linIdx = 99                            'linha para valores nao discriminados
   end if

   if linIdx = 99 then                       'valores nao discriminados ?
      vIvaInc99 = vIvaInc99 + vInc           'valor de incidencia
      vIvaVal99 = vIvaVal99 + vIva           'valor do iva

      ivaCod99$ = "*"                        'codigo
      ivaTax99$ = "*"                        'taxa
      ivaInc99$ = FrmNum$(10.2, vIvaInc99)   'formatar valor de incidencia
      ivaVal99$ = FrmNum$(10.2, vIvaVal99)   'formatar valor do iva
   end if

   if linIdx = 1 then                        'linha 1 ?
      ivaCod01$ = vCod$                      'codigo
      ivaTax01$ = FrmNum$( 2.0, vTax)        'formatar taxa
      ivaInc01$ = FrmNum$(10.2, vInc)        'formatar valor de incidencia
      ivaVal01$ = FrmNum$(10.2, vIva)        'formatar valor do iva
   end if

   if linIdx = 2 then                        'linha 2 ?
      ivaCod02$ = vCod$                      'codigo
      ivaTax02$ = FrmNum$( 2.0, vTax)        'formatar taxa
      ivaInc02$ = FrmNum$(10.2, vInc)        'formatar valor de incidencia
      ivaVal02$ = FrmNum$(10.2, vIva)        'formatar valor do iva
   end if

   if linIdx = 3 then                        'linha 3 ?
      ivaCod03$ = vCod$                      'codigo
      ivaTax03$ = FrmNum$( 2.0, vTax)        'formatar taxa
      ivaInc03$ = FrmNum$(10.2, vInc)        'formatar valor de incidencia
      ivaVal03$ = FrmNum$(10.2, vIva)        'formatar valor do iva
   end if

   if linIdx = 4 then                        'linha 4 ?
      ivaCod04$ = vCod$                      'codigo
      ivaTax04$ = FrmNum$( 2.0, vTax)        'formatar taxa
      ivaInc04$ = FrmNum$(10.2, vInc)        'formatar valor de incidencia
      ivaVal04$ = FrmNum$(10.2, vIva)        'formatar valor do iva
   end if
end if
next
end sub

##

