'Nome       : CtaDia.Sql
'Tipo       : LST
'Data       : 2008/07/29
'Versao     : 1.1
'Descricao  : Listagem de Diario controlada por SQL

'==============================================================================
'#VER - Historia de modificacoes
'==============================================================================

'==============================================================================
#DEF - Definicao global do documento
'==============================================================================
Caracteres invalidos             [CarInv]=#
##


'==============================================================================
#ESP - Campos especificos
'==============================================================================
##




'==============================================================================
#SQL - Comandos SQL
'==============================================================================
Base de dados           [BD]=EmpFic$("EMP","Cemp,Emp_Dat.mdb")


Contas                [Cmd]=CtaDoc=+
   +SELECT * FROM CtaMov{ano} +
   +WHERE Recval <> 255 AND   +
   +[Ct$] BETWEEN '{Opc_Ct.Ini}' AND '{Opc_Ct.Fim}' AND +
   +Dtl BETWEEN {Opc_Dtl.Ini} AND {Opc_Dtl.Fim} AND +
   +[Tdoc$] BETWEEN '{Opc_tdoc.Ini}' AND '{Opc_tdoc.Fim}' AND +
   +[Ndoc$] BETWEEN '{Opc_ndoc.Ini}' AND '{Opc_ndoc.Fim}' +
   +ORDER By Ct$,Dtl,Tdoc$,Ndoc$ 

##

'==============================================================================
#DOC - Configuracao do documento
'==============================================================================
Tipo                       [DocTip]=SQL
Nome                       [DocNom]=DIA,Dirio por Conta c/ Saldos
Vias                       [DocVia]=Original

'formato
Impressora                 [DocPrt]=PAG_W
Linhas por pagina          [DocLpg]=58
Colunas por linha          [DocCol]=132
Formato do papel           [DocPap]=72L
Ajustar pagina             [DocApg]=0

'funcoes de listagem
Listar cabecalho            [FxCAB]=PWS_Cab
Listar linhas               [FxLIN]=PWS_Lin; Sbt1,2
Listar fim                  [FxFIM]=PWS_Fim

'controlo de listagem SQL
Gerador de dados a listar  [SQLDat]=CtaDoc
Subtotalizadores           [SQLSbt]=Ct$
##

'==============================================================================
#DOC - Configuracao do documento
'==============================================================================
Tipo                       [DocTip]=SQL
Nome                       [DocNom]=DIA_Xls,Dirio por Conta c/ Saldos (EXCEL)

'formato
Saida/Impressora           [DocPrt]=NULA
'Saida/Impressora           [DocPrt]=
Linhas por pagina          [DocLpg]=50
Colunas por linha          [DocCol]=80
Formato do papel           [DocPap]=72L
Ajustar pagina             [DocApg]=0
Especifico do documento    [DocEsp]=

'funcoes de listagem
Base para documento         [FxDOC]=XlsPWS
Listar cabecalho            [FxCAB]=XlsPWS_Cab
Listar linhas               [FxLIN]=XlsPWS_Lin,0; Sbt1,0
Listar fim                  [FxFIM]=XlsPWS_Fim

Matriz auxiliar            [DocMat]=CtaDiaS.xls

'controlo de listagem SQL
Gerador de dados a listar  [SQLDat]=CtaDoc
Subtotalizadores           [SQLSbt]=
##

'==============================================================================
#VAR - Variaveis
'==============================================================================
Pag      = Doc_CntPag
DataExt  = FrmVal$(Sig_DtHoje,45,0)

'variaveis a listar
Pag      = Doc_CntPag
DataExt  = FrmVal$(Sig_DtHoje,45,0)
Titulo   = TxTit$("TT=16CPI, LD, PT=66C, TL=16CPI",Memtxt$(1))

Dtl      = FrmVal$(SqlCmp("Dtl"),42,0)
Ctn      = SqlCmp$("Ct$")
Ndoc     = SqlCmp$("Tdoc$")+" "+FrmNdo$("06",SqlCmp$("Tdoc$"),SqlCmp$("Ndoc$"))
Dtv      = FrmVal$(SqlCmp("DtV"),42,0)
Descr    = SqlCmp$("Descr$")
Val      = FrmMoe$("",19,SqlCmp("Vl"))
Tv       = SqlCmp$("Tv$")
##


'==============================================================================
#INC - Variaveis comuns
'==============================================================================
Variaveis  comuns                 =[SIG_Dir.Div],LsComVar.std
##



'==============================================================================
#PGM - Programa/Funcoes
'==============================================================================
'---------------------------------------------------------->'Comentario (61)
'------------------------------------------------->'Comentario (52)
'------------------------------------->'Comentario (40)
'=============================================================================
' Impressao no formato grafico
'=============================================================================
SUB FxIni 'funcao de inicializacao
Call SigLstIni
Saldo=0
SSaldo=0
TotDeb=0
TotCre=0
'msgbox "","","FxInI"
End sub

Sub PWS_Cab 'cabecalho da pagina com Saldo s/ Analitica
'msgbox "","","PWS_cab"


Call SigLstCab
MargemD=190
'titulo 1 linha
T1Col1=  2
T1Col2= 50
T1Col3= 98
T1Col4=150

'titulo 2 linha
T2Col1=  0
T2Col2= 20
T2Col3= 40
T2Col4= 55
T2Col5= 75
T2Col6=125
T2Col7=150
T2Col8=175
'T2Col9=175

'posicao linhas de titulo
Lin1=2                            	'linha 1
Lin2=5					'linha2

PrWIN COR_T,  CorTitLst                 'cor de titulo
PrWIN FON  ,   9,   1                   'activar fonte
PrWin Ajt_B, Margem, 26

PrWIN FON,"BOLD+"
PrWIN TX_N,T1Col1,Lin1,"Data"
PrWIN TX_N,T2Col1,Lin2,"Movim."
PrWIN TX_N,T2Col2,Lin2,"Conta"
PrWIN TX_N,T2Col3,Lin2,"Doc."
PrWIN TX_N,T1Col2+7,Lin1,"Data"
PrWIN TX_N,T2Col4,Lin2,"Venc."
PrWIN TX_N,T2Col5,Lin2,"Descrio"
PrWIN TX_N,T1Col3+30,Lin1,"Contabilidade Geral"
PrWIN TX_N,T2Col6-3,Lin2,"Dbito"
PrWIN TX_N,T2Col7,Lin2,"Crdito"
'PrWIN TX_N,T1Col4,Lin1,"Contabilidade Analtica"
PrWIN TX_N,T2Col8,Lin2,"Saldo"
PrWIN FON,"BOLD-"

PrWIN COR_T,CorTraco                            'cor de linhas
PrWIN GR_LI, 0,  0, MargemD, 0               	'linha
PrWIN GR_LI, 0, 10, MargemD, 10               	'linha

PrWIN FON  ,   8,   1                           'activar fonte
PrWIN COR_T,CorLin                              'cor de linhas
InicioEscrita=33
end sub

Sub PWS_Lin 'linha normal
'msgbox "","","PWS_Lin"
LCol1 =  1
LCol2 = 20
LCol3 = 38
LCol4 = 59
LCol5 = 75
LCol6 = 95
LCol7 =130
LCol8 =155
'LCol9 =175
LCol10=MargemD
Sin$=""
if SqlCmp$("Tv$") = "D"   then
   Saldo = saldo + SqlCmp("Vl")
   TotDeb = TotDeb + SqlCmp("Vl")
else
   Saldo = saldo - SqlCmp("Vl")
   TotCre = TotCre + SqlCmp("Vl")
end if

SalAcum = Saldo
if SalAcum > 0 then
   Sin$ = "D"
end if
if SalAcum < 0 then
   Sin$ = "C"
   salAcum = -1 * salAcum
end if

Saldo$ = FrmMoe$("",19,SalAcum)+" "+Sin$

PrWIN AJT_B,  Margem, InicioEscrita+Doc_CntLin*4          	'posicao base
PrWIN TX_N,    LCol1,0,@Dtl
PrWIN TX_N,    LCol2,0,@Ctn
PrWIN TX_NP,   LCol3,0,"N",@Ndoc
PrWIN TX_N,    LCol4,0,@Dtv
PrWIN TX_N,    LCol5,0,@Descr
if SqlCmp$("Tv$") = "D" then
   PrWIN TX_NP,   LCol6,0,"N",@Val
else
   PrWIN TX_NP,   LCol7,0,"N",@Val
end if
PrWIN TX_NP,   LCol8,0,"N",Saldo$
SSaldo = Saldo
end sub

SUB PWS_LinSbt1 'subtotal 1
Cnt$=SbtInf$("ANT",1)                         'grupo
'msgbox "","",Cnt$
PrWin FON,"BOLD+"
PrWin FON,"ITAL+"
PrWIN COR_T,     CorTitLst                         'cor total geral
PrWIN AJT_B,  Margem, 37+Doc_CntLin*4   'posicao base
fx=CtaContaLer(Cnt$)      'ler conta
SctDesc$   = "Total: "+Cta_Mst_Ct$+" - "+Cta_Mst_Nome$
PrWIN TX_N,     LCol1,0,SctDesc$
Sin$=""
if SSaldo > 0 then
   Sin$ = "D"
end if
if SSaldo < 0 then
   Sin$ = "C"
   Ssaldo = -1 * Ssaldo
end if
TotDeb$ = FrmMoe$("",19,TotDeb)
TotCre$ = FrmMoe$("",19,TotCre)
SSaldo$ = FrmMoe$("",19,SSaldo)+" "+Sin$
PrWIN COR_T,CorLin                                 'cor de linhas
PrWIN TX_NP,    LCol6,0,"N",TotDeb$
PrWIN TX_NP,    LCol7,0,"N",TotCre$
PrWIN TX_NP,    LCol8,0,"N",SSaldo$
PrWin FON,"BOLD-"
PrWin FON,"ITAL-"
tmp=CntLin("INC",2)                                'contar linha
saldo  = 0
SSaldo = 0
TotDeb = 0
TotCre = 0
end sub

Sub PWS_FimAjt 'subtotal por pagina
'msgbox "","","fIMaJT"
TxTit$="Sub-total dos movimentos"
call SigLstRod
PrWIN GR_LI, 0,  0, MargemD, 0               	'linha
PrWin FP
end sub

Sub PWS_Fim 'total geral
'msgbox "","","PWS_Fim"
txtit$="Total dos movimentos"

call SigLstRod
PrWIN GR_LI, 0,  0, MargemD, 0               	'linha
'Call SigLstRod
PrWin FP
end sub

'==============================================================================
'= XLS - Funcoes comuns =======================================================
'==============================================================================
Sub Xls_DocIni 'inicializar documento
dfi$ = FicEmp$("EMP","Ext","dExcel",cmo$)          'directorio de documentos EXCEL
nfi$ = "RND:CtaDiaS.xls"                            'nome do ficheiro
cmo$ = SigCmoCur$("MIX")                           'modulo corrente
ficDoc$ = FicTmp$(dfi$, nfi$)                      'ficheiro para documento
res = DirCri("D", dfi$)                            'criar directorio para documento

xlsMatNom$ = DocOpc$("DocMat")                     'nome do ficheiro matriz
xlsMat$    = DocOpc$("DocMat+SBT")                 'endereco do ficheiro matriz

res = FicCop(xlsMat$, ficDoc$)                     'criar ficheiro (copia de matriz)

res = XlsPrp(0)                                    'preparar EXCEL
res = XlsDocLer(ficDoc$)                           'ler ficheiro
end sub


Sub Xls_LinFim 'fim de linhas
'res = XlsLinEli(xlsLin, 1)                         'eliminar linha - ultima
'res = XlsLinEli(xlsLba, 1)                         'eliminar linha - primeira

'res = XlsIdePsq("PO_FIM")                          'pesquisar posicao final
'linFim = XlsIdePsqRes("L")                         'linha da posicao final
end sub

Sub Xls_DocFim 'terminar documento
res = XlsDocDir$("A", dfi$)                        'activar directorio
res = XlsDocGrv(ficDoc$)                           'gravar ficheiro

res = XlsVer(0)                                    'mostrar EXCEL - normal
'res = XlsVer(1)                                    'mostrar EXCEL - maximizado
res = XlsLib(0)                                    'libertar EXCEL
end sub


Sub Xls_LinInc 'incrementar linha
xlsLsa = xlsLin                                    'linha de saida
res = XlsLinIns(xlsLin, 1)                         'juntar linha

'seguinte
xlsLin = xlsLin + 1                                'contar linha
end sub


'==============================================================================
'= Listagem para EXCEL ========================================================
'==============================================================================
Sub XlsPWS_DocIni 'inicializar documento
call Xls_DocIni                                    'inicializar documento
call XlsPWS_Prep                                   'preparar
call XlsPWS_Cab                                    'cabecalho
'msgbox "","","XlsPWS_DocIni"
end sub


Sub XlsPWS_DocFim 'terminar documento
linIni = linBav                                    'linha inicial
linFim = linCnt                                    'linha final

'mostrar
call Xls_DocFim                                    'terminar/mostrar documento
end sub

Sub XlsPWS_Prep 'preparar para listar
res = XlsWks("Valores")                             'activar worksheet

'res = XlsIdePsq("PO_BAS")                          'pesquisar posicao base
'linBav = XlsIdePsqRes("L")                         'linha da posicao base

'xlsLba = linBav                                    'linha base
'msgbox "","","XlsPWS_Prep"

empCab$     = Emp_Inf_Cod$+" - "+Emp_Inf_Nome$
DataDia$    = FrmDt$("EXT", Sig_DtHoje)                'data para listagem
res = XlsLst(2, 2, empCab$)                 'Empresa
res = XlsLst(2, 9, DataDia$)                'Data Listagem
CtG$ = ""
xlsLin = 9                                          'Linha Inicial
saldo  = 0
SSaldo = 0
TotDeb = 0
TotCre = 0
NaoLista = 0
end sub

Sub XlsPWS_Cab 'cabecalho
'msgbox "","","XlsPWS_Cab"
end sub

Sub Cabecalho 'Imprime Cabealho
LinUsa = XlsLin + 6

zon$= XlsZon$(linUsa-1, 2)                        'zona de celula
res = XlsAli(zon$, "<")                            'alinhamento
res = XlsLst(LinUsa-1, 2, empCab$)                 'Empresa
res = XlsLst(LinUsa-1, 9, DataDia$)                'Data Listagem

zon$= XlsZonNum$("L", LinUsa)                       'zona da linha
res = XlsDimLin(zon$,26)                         'activar fonte bold

res = XlsFormCop(3,2,LinUsa,2)
res = XlsFormCop(3,3,LinUsa,3)
res = XlsFormCop(3,4,LinUsa,4)
res = XlsFormCop(3,5,LinUsa,5)
res = XlsFormCop(3,6,LinUsa,6)
res = XlsFormCop(3,7,LinUsa,7)
res = XlsFormCop(3,8,LinUsa,8)
res = XlsFormCop(3,9,LinUsa,9)
res = XlsFormCop(3,10,LinUsa,10)

zon$= XlsZonNum$("L", LinUsa+2)                       'zona da linha
res = XlsDimLin(zon$,20)                         'activar fonte bold

res = XlsFormCop(5,2,LinUsa+2,2)
res = XlsFormCop(5,3,LinUsa+2,3)
res = XlsFormCop(5,4,LinUsa+2,4)
res = XlsFormCop(5,5,LinUsa+2,5)
res = XlsFormCop(5,6,LinUsa+2,6)
res = XlsFormCop(5,7,LinUsa+2,7)
res = XlsFormCop(5,8,LinUsa+2,8)
res = XlsFormCop(5,9,LinUsa+2,9)
res = XlsFormCop(5,10,LinUsa+2,10)

res = XlsFormCop(7,2,LinUsa+4,2)
res = XlsFormCop(7,3,LinUsa+4,3)
res = XlsFormCop(7,4,LinUsa+4,4)
res = XlsFormCop(7,5,LinUsa+4,5)
res = XlsFormCop(7,6,LinUsa+4,6)
res = XlsFormCop(7,7,LinUsa+4,7)
res = XlsFormCop(7,8,LinUsa+4,8)
res = XlsFormCop(7,9,LinUsa+4,9)
res = XlsFormCop(7,10,LinUsa+4,10)

res = XlsFormCop(8,2,LinUsa+5,2)
res = XlsFormCop(8,3,LinUsa+5,3)
res = XlsFormCop(8,4,LinUsa+5,4)
res = XlsFormCop(8,5,LinUsa+5,5)
res = XlsFormCop(8,6,LinUsa+5,6)
res = XlsFormCop(8,7,LinUsa+5,7)
res = XlsFormCop(8,8,LinUsa+5,8)
res = XlsFormCop(8,9,LinUsa+5,9)
res = XlsFormCop(8,10,LinUsa+5,10)

res = XlsFormCop(XlsLin,2,LinUsa+6,2)
res = XlsFormCop(XlsLin,3,LinUsa+6,3)
res = XlsFormCop(XlsLin,4,LinUsa+6,4)
res = XlsFormCop(XlsLin,5,LinUsa+6,5)
res = XlsFormCop(XlsLin,6,LinUsa+6,6)
res = XlsFormCop(XlsLin,7,LinUsa+6,7)
res = XlsFormCop(XlsLin,8,LinUsa+6,8)
res = XlsFormCop(XlsLin,9,LinUsa+6,9)
res = XlsFormCop(XlsLin,10,LinUsa+6,10)

res = XlsFormCop(XlsLin+1,2,LinUsa+7,2)
res = XlsFormCop(XlsLin+1,3,LinUsa+7,3)
res = XlsFormCop(XlsLin+1,4,LinUsa+7,4)
res = XlsFormCop(XlsLin+1,5,LinUsa+7,5)
res = XlsFormCop(XlsLin+1,6,LinUsa+7,6)
res = XlsFormCop(XlsLin+1,7,LinUsa+7,7)
res = XlsFormCop(XlsLin+1,8,LinUsa+7,8)
res = XlsFormCop(XlsLin+1,9,LinUsa+7,9)
res = XlsFormCop(XlsLin+1,10,LinUsa+7,10)

res = XlsFormCop(XlsLin+3,2,LinUsa+9,2)
res = XlsFormCop(XlsLin+3,3,LinUsa+9,3)
res = XlsFormCop(XlsLin+3,4,LinUsa+9,4)
res = XlsFormCop(XlsLin+3,5,LinUsa+9,5)
res = XlsFormCop(XlsLin+3,6,LinUsa+9,6)
res = XlsFormCop(XlsLin+3,7,LinUsa+9,7)
res = XlsFormCop(XlsLin+3,8,LinUsa+9,8)
res = XlsFormCop(XlsLin+3,9,LinUsa+9,9)
res = XlsFormCop(XlsLin+3,10,LinUsa+9,10)

XlsLin = LinUsa + 6
end sub

Sub ListaConta                  ' Listar o n da conta
res = XlsLst(XlsLin-4, 3, CtUsa$)              'Titulo
fx=CtaContaLer(CtUsa$)      'ler conta
res = XlsLst(XlsLin-4, 4, Cta_Mst_Nome$) 
end Sub

Sub TrataCab                    ' Tratar Cabealho
If NaoLista = 1 then
   call Cabecalho
end if
call ListaConta
NaoLista = 1
TotDeb$ = FrmMoe$("",19,TotDeb)
TotCre$ = FrmMoe$("",19,TotCre)
SSaldo$ = FrmMoe$("",19,SSaldo)
res = XlsLst(XlsLin-9, 7, TotDeb$)              'Titulo
res = XlsLst(XlsLin-9, 8, TotCre$)              'Titulo
res = XlsLst(XlsLin-9, 9, SSaldo$)              'Titulo

Ctg$ = CtUsa$
Saldo  = 0
SSaldo = 0
TotDeb = 0
TotCre = 0

end Sub

Sub XlsPWS_Lin 'linha de valores
'msgbox "","",XlsLin
CtUsa$ = SqlCmp$("Ct$")

if CtUsa$ <> CtG$   then
   Call TrataCab
end if

Dtl$     = FrmVal$(SqlCmp("Dtl"),44,0)
Dtv$     = FrmVal$(SqlCmp("DtV"),44,0)
Tdoc$    = SqlCmp$("Tdoc$")
Ndoc$    = FrmNdo$("06",SqlCmp$("Tdoc$"),SqlCmp$("Ndoc$"))
Descr$   = SqlCmp$("Descr$")
Val$     = FrmMoe$("",19,SqlCmp("Vl"))
Tv$      = SqlCmp$("Tv$")

'call Xls_LinInc                            'incrementar linha

res = XlsLst(Xlslin, 2, Dtl$)              'Data Lanamento
res = XlsLst(Xlslin, 3, Dtv$)              'Data Vencimento
res = XlsLst(Xlslin, 4, Tdoc$)             'Dirio
res = XlsLst(Xlslin, 5, Ndoc$)             'Documento
res = XlsLst(Xlslin, 6, Descr$)            'Descrio

if SqlCmp$("Tv$") = "D"   then
   Saldo = saldo + SqlCmp("Vl")
   TotDeb = TotDeb + SqlCmp("Vl")
   res = XlsLst(Xlslin, 7, Val$)            'Valor Debito
else
   Saldo = saldo - SqlCmp("Vl")
   TotCre = TotCre + SqlCmp("Vl")
   res = XlsLst(Xlslin, 8, Val$)            'Valor Credito
end if

'SalAcum = Saldo
'if SalAcum < 0    then
'   salAcum = -1 * salAcum
'end if

Saldo$   = FrmMoe$("",19,Saldo)
res = XlsLst(Xlslin, 9, Saldo$)            'Saldo
if Saldo > 0   then
   Sin$ = "D"
else
   Sin$ = "C"
end if
res = XlsLst(Xlslin,10, Sin$)               'Debito/Credito

SSaldo = Saldo

xlsLin = xlsLin + 1                                'contar linha
res = XlsLinIns(xlsLin, 1)                         'juntar linha
end sub

'---------------------------------------------------------->'Comentario (61)
'------------------------------------------------->'Comentario (52)
'------------------------------------->'Comentario (40)

'- Linha de acumulados --------------------------------------------------------
Sub XlsPWS_LinAcmPrp 'preparar valores dos acumulados
xDtl$     = ""                                     'data do movimento
xDtv$     = ""                                     'data de vencimento
xTdo$     = ""                                     'diario
xNdo$     = ""                                     'documento
xDes$     = "Mov. Anterior"                        'descricao
vDeb      = MemNum(31)                             'acumulado debito 
vCre      = MemNum(32)                             'acumulado credito
vVls      = MemNum(33)                             'valor do saldo
end sub


Sub XlsPWS_LinVad 'valores anteriores acumulados (debito)
call XlsExt_LinAcmPrp                              'preparar valores acumulados
vTps$ = "D"                                        'tipo

call XlsExt_LinAcmExe                              'executar listagem da linha
end sub


Sub XlsExt_LinVac 'valores anteriores acumulados (credito)
call XlsExt_LinAcmPrp                              'preparar valores acumulados
vTps$ = "C"                                        'tipo

call XlsExt_LinAcmExe                              'executar listagem da linha
end sub


Sub XlsExt_LinAcmExe 'executar listagem da linha
call Xls_LinInc                                    'incrementar linha
liUsa =  xlsLsa                                    'linha a usar
call Xls_LinInc                                    'incrementar linha

res = XlsLst(liUsa, coDes, xDes$)                  'descricao
res = XlsLst(liUsa, coDeb, vDeb)                   'valor mensal - debito
res = XlsLst(liUsa, coCre, vCre)                   'valor mensal - credito
res = XlsLst(liUsa, coVls, vVls)                   'valor do saldo
res = XlsLst(liUsa, coTps, vTps$)                  'tipo do saldo

'zon$= XlsZon$(liUsa, coXxx, liUsa, coZzz)          'zona
zon$= XlsZonNum$("L", liUsa)                       'zona da linha
'zon$= XlsZon$(liUsa, coNom)                        'zona de celula

res = XlsFon(zon$, ",,B+")                         'activar fonte bold
'res = XlsFon(zon$, ",,I+")                         'activar fonte italico
'res = XlsAli(zon$, ">")                            'alinhamento



end sub


'- Linha de movimento ---------------------------------------------------------
Sub XlsExt_LinMovPrp 'preparar valores do movimento
xDtl$     = FrmDt$("",MemNum(11))                  'data de lancamento
xDtv$     = FrmDt$("",MemNum(12))                  'data de vencimento
xTdo$     = Memtxt$(10)                            'diario
xNdo$     = FrmNdo$("06",Memtxt$(10),MemTxt$(11))  'documento
xDes$     = MemTxt$(14)                            'descricao
vDeb      = MemNum(21)                             'movimento debito 
vCre      = MemNum(22)                             'movimento credito
vVls      = MemNum(23)                             'valor do saldo
end sub


Sub XlsExt_LinDeb 'linha de valores com saldo devedor
call XlsExt_LinMovPrp                              'preparar valores do movimento
vTps$ = "D"                                        'tipo do saldo

call XlsExt_LinExe                                 'executar listagem da linha
end sub


Sub XlsExt_LinCre 'linha de valores com saldo devedor
call XlsExt_LinMovPrp                              'preparar valores do movimento
vTps$ = "C"                                        'tipo do saldo

call XlsExt_LinExe                                 'executar listagem da linha
end sub


Sub XlsExt_LinExe 'executar listagem da linha
call Xls_LinInc                                    'incrementar linha

res = XlsLst(xlsLsa, coDtl, xDtl$)                 'data do movimento
res = XlsLst(xlsLsa, coDtv, xDtv$)                 'data de vencimento
res = XlsLst(xlsLsa, coTdo, xTdo$)                 'diario
res = XlsLst(xlsLsa, coNdo, xNdo$)                 'documento
res = XlsLst(xlsLsa, coDes, xDes$)                 'descricao

if vDeb <> 0 then                                  'listar debito ?
   res = XlsLst(xlsLsa, coDeb, vDeb)               'valor debito
end if

if vCre <> 0 then                                  'listar credito ?
   res = XlsLst(xlsLsa, coCre, vCre)               'valor credito
end if

res = XlsLst(xlsLsa, coVls, vVls)                  'valor do saldo
res = XlsLst(xlsLsa, coTps, vTps$)                 'tipo do saldo
End sub


'- Terminar/Totais ------------------------------------------------------------
Sub XlsExt_Fim 'terminar
call Xls_LinFim                                    'fim de linhas

liTmv = LinFim                                     'linha para totais de movimentos
liLtr = liTmv + 1                                  'linha para saldo de letras
liTge = liLtr + 1                                  'linha para totais gerais

'conta corrente
ccDeb     = MemNum(41)                             'acumulado a debito
ccCre     = MemNum(42)                             'acumulado a credito
ccVls     = MemNum(43)                             'Valor do saldo
ccTps$    = MemTxt$(43)                            'tipo do saldo

'letras
lrVlu     = MemNum(44)                             'valor a usar
lrVls     = abs(lrVlu)                             'valor a listar
if lrVlu < then                                    'saldo credor ?
   lrTps$ = "C"                                    'tipo do saldo
else
   lrTps$ = "D"                                    'tipo do saldo
end if

'total geral
tgVls     = MemNum(45)                             'Valor do saldo
tgTps$    = MemTxt$(45)                            'tipo do saldo


'listar conta corrente
res = XlsLst(liTmv, coDeb, ccDeb)                  'acumulado a debito
res = XlsLst(liTmv, coCre, ccCre)                  'acumulado a credito
res = XlsLst(liTmv, coVls, ccVls)                  'valor do saldo
res = XlsLst(liTmv, coTps, ccTps$)                 'tipo do saldo

'listar letras
res = XlsLst(liLtr, coVls, lrVls)                  'valor do saldo
res = XlsLst(liLtr, coTps, lrTps$)                 'tipo do saldo

'listar total geral
res = XlsLst(liTge, coVls, tgVls)                  'valor do saldo
res = XlsLst(liTge, coTps, tgTps$)                 'tipo do saldo

'terminar/mostrar
xlsLin = xlsLin - 3                                'descontar linhas de totais
res = XlsWksAct("A", 1)                            'activar worksheet
end sub


##

'==============================================================================
#INC - Funcoes comuns
'==============================================================================
Funcoes comuns                    =[SIG_Dir.Div],LsComPgm.std
##


